/******************************************************************************
* Software License Agreement *
* *
* The software supplied herewith by Microchip Technology Incorporated *
* (the "Company") for its dsPIC controller is intended and supplied to *
* you, the Company's customer, for use solely and exclusively on *
* Microchip dsPIC products. The software is owned by the Company and/or *
* its supplier, and is protected under applicable copyright laws. All *
* rights are reserved. Any use in violation of the foregoing *
* restrictions may subject the user to criminal sanctions under *
* applicable laws, as well as to civil liability for the breach of the *
* terms and conditions of this license. *
* *
* THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, *
* WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, *
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR *
* PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, IN ANY *
* CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR CONSEQUENTIAL *
* DAMAGES, FOR ANY REASON WHATSOEVER. *
* *
*******************************************************************************
*
*	Pevzato ze strnek www.microchip.com 
*	Upravil Jakub erch
*
*	Pomoc asovae Timer1 blikme s diodou pipojenou
*		- na portu B6 pokud nen stisknut tlatko
*		- na portu B7 pokud je stisknut tlatko
*	Tlatko je pipojeno na port D0 (nem vnitn pull-up rezistor)
*
*	dky tkajc se hardwaru maj koment opaten temi hvzdikami ***, 
*	take je snadn je najt a pozmnit, pokud mte LEDky a tlatko pipojeny 
*	jinam ne v tomto pkladu.
*
******************************************************************************/
#include "p30F3012.h"
//-----------------------------------------------------------------------------
//Konfiguran bity (s bootloaderem jsou bezvznamn, protoe se pouv jeho
//												vlastn nastaven tchto bit)
_FOSC(CSW_FSCM_OFF & XT_PLL8);	//Osciltor krystal 8x  PLL
_FWDT(WDT_OFF); 				//Watchdog vypnut
_FBORPOR(PBOR_OFF & BORV_27 & PWRT_16 & MCLR_EN); //Brownout vypnut, povolen reset MCLR
_FGS(CODE_PROT_OFF); 			//Ochrana kdu vypnuta
//-----------------------------------------------------------------------------
//Konstanty pouit v programu
#define FCY 7372800*8/4 	//Poet instrukc za sekundu 
								//FCY = frekvence x PLL / 4 
								//(dsPIC m 4  takty na jednu instrukci)
//=============================================================================
//Hlavn program
//Nastavme vstupy, vstupy a asova a pak u jen ekme na periody asovae a pepnme
//jednu nebo druhou LED diodu podle stavu tlatka
int main(void)
{
	LATB = 0x0000;  			// *** Vypneme LEDky
	TRISB = 0b1111111100111111; // *** Piny B6 a B7 nastavme jako vstupn
	T1CON = 0; 					//Vynulujeme konfiguran registr asovae
	TMR1 = 0; 					//Vynulujeme hodnotu asovae
	PR1 = FCY/256/5; 			//Nastavme periodu na 1/5 sekundy
	T1CON = 0x8030; 			//Zapneme asova Timer1 s peddliem 1:256

//Potebn nastaven je provedeno, meme jt na hlavn smyku programu

	while(1) 					//Nekonen cyklus
	{
		while(!IFS0bits.T1IF){} //ekme na periodu asovae
		IFS0bits.T1IF = 0; 		//Vymaeme pznak asovae 
		if(PORTDbits.RD0)		// *** Je stisknut tlatko?
		{	//Tlatko nen stisknut (logick 1)
			LATBbits.LATB6 ^= 1;// *** Invertujeme vstup LED1
			LATBbits.LATB7 = 0; // *** Vypneme LED2
		}
		else
		{	//Tlatko je stisknut (logick 0)
			LATBbits.LATB6 = 0; // *** Vypneme LED1
			LATBbits.LATB7 ^= 1;// *** Invertujeme vstup LED2
		}
	}
} //Konec main()

//=============================================================================
//Error traps (pasti na chyby)
//Procesory dsPIC jsou vybaveny nkolika peruenmi, ke kterm dojde pi nejzvanjch
//chybch procesoru. To pin monost programov eit i tyto kritick situace.
//Nsleduj jednoduch rutiny, kter v naem ppad pi tchto situacch pouze rozsvt 
//ob diody LED a sko do nekonenho syklu. 
//-----------------------------------------------------------------------------
//Oscillator Fail Error - chyba osciltoru
void _ISR _OscillatorFail(void)
{
	LATBbits.LATB6 = 1; 		// *** Zapneme LED1
	LATBbits.LATB7 = 1; 		// *** Zapneme LED2
	while(1); //Nekonen cyklus
}
//-----------------------------------------------------------------------------
//Address Error - chyba adresy
void _ISR _AddressError(void)
{
	LATBbits.LATB6 = 1; 		// *** Zapneme LED1
	LATBbits.LATB7 = 1; 		// *** Zapneme LED2
	while(1); //Nekonen cyklus
}
//-----------------------------------------------------------------------------
//Stack Error - chyba zsobnku
void _ISR _StackError(void)
{
	LATBbits.LATB6 = 1; 		// *** Zapneme LED1
	LATBbits.LATB7 = 1; 		// *** Zapneme LED2
	while(1); //Nekonen cyklus
}
//-----------------------------------------------------------------------------
//Math (Arithmetic) Error - chyba vpot
void _ISR _MathError(void)
{
	LATBbits.LATB6 = 1; 		// *** Zapneme LED1
	LATBbits.LATB7 = 1; 		// *** Zapneme LED2
	while(1); //Nekonen cyklus
}
